//=============================================================================
// InfoWindow.js
//=============================================================================

/*:
 * @plugindesc 情報表示ウィンドウをメニュー画面に追加するプラグイン
 * @author Me
 *
 * @help 情報表示ウィンドウをメニュー画面上に追加します。
 *
 */
 
 ( function() {
    'use strict';
    const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function( command, args ) {
        _Game_Interpreter_pluginCommand.call( this, command, args );

        if( command === 'INFOON' ) {// 渡されたコマンド名をチェック
		this._InfoWindow(true);// コマンドの実行部分
		}

		if( command === 'INFOOFF' ) {// 渡されたコマンド名をチェック
		this._InfoWindow(false);// コマンドの実行部分
		}

    };
} )();


(function() {

	// マップ上にウィンドウ表示するよ宣言
	var Scene_map_start = Scene_Map.prototype.start;
	Scene_Map.prototype.start = function() {
		Scene_map_start.call(this);
	    this._InfoWindow = new Window_Info();
	    this.addWindow(this._InfoWindow);
	    if($gameSwitches.value(1) == true){SceneManager._scene._windowLayer.children[7].visible = true;}
	    if($gameSwitches.value(1) == false){SceneManager._scene._windowLayer.children[7].visible = false;}
	};
    var _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        this._InfoWindow.setText();
        if($gameSwitches.value(1) == true){SceneManager._scene._windowLayer.children[7].visible = true;}
	    if($gameSwitches.value(1) == false){SceneManager._scene._windowLayer.children[7].visible = false;}
    };
	
	// ここからメニューウィンドウ作り始まります。
	function Window_Info() {
	    this.initialize.apply(this, arguments);
	}

	Window_Info.prototype = Object.create(Window_Base.prototype);
	Window_Info.prototype.constructor = Window_Info;
	Window_Info.prototype.initialize = function() {
		var x = 0;
		var y = 89;
	    var width = 205;
	    var height = 80;
	    Window_Base.prototype.initialize.call(this, x, y, width, height);
	};

	Window_Info.prototype.setText = function(str) {
		this._text = str;
		this.refresh();
	};
	
	// ウィンドウに載せる内容
	Window_Info.prototype.refresh = function() {
	    this.contents.clear();
		this.changeTextColor(this.textColor(0));
        //this.drawIcon(210, 1, 1);
		this.drawText("　　" + $gameVariables.value(6) + "일　　" + $gameVariables.value(13) + "각" ,10, 0);
		this.drawText($gameVariables.value(11) + "　요력　" + $gameVariables.value(12) ,10, 30);
	};
	
	// フォントサイズ
	Window_Info.prototype.standardFontSize = function() {
    	return 18;
    };
	// ウィンドウの透明度
	Window_Info.prototype.standardBackOpacity = function() {
    	return 160;
	};
    // ウィンドウの余白
	Window_Info.prototype.standardPadding = function() {
    	return 6;
	};
	// ウィンドウの色調
	Window_Info.prototype.updateTone = function() {
    	this.setTone(0, 0, 0);
	};
	
})();